/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.recipe.crafting;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import javax.annotation.Nullable;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1865;
import net.minecraft.class_1869;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_5455;
import net.minecraft.class_8566;
import slimeknights.mantle.item.RetexturedBlockItem;
import slimeknights.mantle.recipe.MantleRecipeSerializers;
import slimeknights.mantle.util.JsonHelper;

public class ShapedRetexturedRecipe
extends class_1869 {
    private final class_1856 texture;
    private final boolean matchAll;

    protected ShapedRetexturedRecipe(class_1869 orig, class_1856 texture, boolean matchAll) {
        super(orig.method_8114(), orig.method_8112(), orig.method_45441(), orig.method_8150(), orig.method_8158(), orig.method_8117(), orig.method_8110((class_5455)class_5455.field_40585));
        this.texture = texture;
        this.matchAll = matchAll;
    }

    public class_1799 getRecipeOutput(class_1792 texture) {
        return RetexturedBlockItem.setTexture(this.method_8110((class_5455)class_5455.field_40585).method_7972(), class_2248.method_9503((class_1792)texture));
    }

    public class_1799 method_17727(class_8566 craftMatrix, class_5455 registryAccess) {
        class_1799 result = super.method_17727(craftMatrix, registryAccess);
        class_2248 currentTexture = null;
        for (int i = 0; i < craftMatrix.method_5439(); ++i) {
            class_2248 block;
            class_1799 stack = craftMatrix.method_5438(i);
            if (stack.method_7960() || !this.texture.method_8093(stack) || (block = stack.method_7909() == result.method_7909() ? RetexturedBlockItem.getTexture(stack) : class_2248.method_9503((class_1792)stack.method_7909())) == class_2246.field_10124) continue;
            if (currentTexture == null) {
                currentTexture = block;
                if (this.matchAll) continue;
                break;
            }
            if (currentTexture == block) continue;
            currentTexture = null;
            break;
        }
        if (currentTexture != null) {
            return RetexturedBlockItem.setTexture(result, currentTexture);
        }
        return result;
    }

    public class_1865<?> method_8119() {
        return MantleRecipeSerializers.CRAFTING_SHAPED_RETEXTURED;
    }

    public class_1856 getTexture() {
        return this.texture;
    }

    public static class Serializer
    implements class_1865<ShapedRetexturedRecipe> {
        public ShapedRetexturedRecipe fromJson(class_2960 recipeId, JsonObject json) {
            class_1869 recipe = (class_1869)field_9035.method_8121(recipeId, json);
            class_1856 texture = class_1856.method_52177((JsonElement)JsonHelper.getElement(json, "texture"));
            boolean matchAll = false;
            if (json.has("match_all")) {
                matchAll = json.get("match_all").getAsBoolean();
            }
            return new ShapedRetexturedRecipe(recipe, texture, matchAll);
        }

        @Nullable
        public ShapedRetexturedRecipe fromNetwork(class_2960 recipeId, class_2540 buffer) {
            class_1869 recipe = (class_1869)field_9035.method_8122(recipeId, buffer);
            return recipe == null ? null : new ShapedRetexturedRecipe(recipe, class_1856.method_8086((class_2540)buffer), buffer.readBoolean());
        }

        public void toNetwork(class_2540 buffer, ShapedRetexturedRecipe recipe) {
            field_9035.method_8124(buffer, (class_1860)recipe);
            recipe.texture.method_8088(buffer);
            buffer.writeBoolean(recipe.matchAll);
        }
    }
}

